/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.rsf;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;

public class RsfMachineInfo
implements PersistentData {
    private static final String TRACE_MASKT = "XRSFMT T";
    private static final String TRACE_MASKF = "XRSFMT F";
    private static final String TRACE_MASKD = "XRSFMT D";
    private String machineType;
    private String machineModel;
    private String machineSerial;
    private String feature = null;
    private boolean localMachine = false;
    private final int version = 0;
    private static boolean checkedConfigFile = false;
    private static boolean configFileExists = false;
    private static final String configFilename = "iqyvpdc.dat";
    private static final long serialVersionUID = 1L;

    public RsfMachineInfo(String machType, String machModel, String machSerial) throws IllegalArgumentException {
        if (machType == null || machModel == null || machSerial == null) {
            throw new IllegalArgumentException();
        }
        this.machineType = machType.trim();
        this.machineModel = machModel.trim();
        this.machineSerial = machSerial.trim();
    }

    protected RsfMachineInfo(String machType, String machModel, String machSerial, boolean local) throws IllegalArgumentException {
        if (machType == null || machModel == null || machSerial == null) {
            throw new IllegalArgumentException();
        }
        this.machineType = machType.trim();
        this.machineModel = machModel.trim();
        this.machineSerial = machSerial.trim();
        this.localMachine = local;
    }

    public static boolean isConfigFile() {
        if (!checkedConfigFile) {
            try {
                String configPath = BaseFileControl.getFilePath(configFilename);
                File configFile = new File(configPath + configFilename);
                checkedConfigFile = true;
                if (configFile.exists()) {
                    configFileExists = true;
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "RsfMachineInfo:isConfigFile: BaseFileControl error");
            }
        }
        return configFileExists;
    }

    public static RsfMachineInfo getLocalMachineInfo() throws HException {
        HMC hmc = HMC.getHMC();
        String serial = hmc.getMachineSerial();
        return new RsfMachineInfo(hmc.getMachineType(), hmc.getMachineModel(), serial, true);
    }

    public int getVersion() {
        return 0;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getMachineModel() {
        return this.machineModel;
    }

    public String getMachineSerial() {
        String serial = this.machineSerial;
        if (this.localMachine) {
            int serialLength = serial.length();
            if (serialLength >= 12) {
                serial = serial.substring(3, 5) + serial.substring(serialLength - 5);
            } else if (serialLength > 7) {
                serial = serial.substring(0, 2) + serial.substring(serialLength - 5);
            }
        }
        return serial;
    }

    public String getMachineFeature() {
        return this.feature;
    }

    public void setMachineFeature(String feature) {
        this.feature = feature;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("<MINFO>");
        buffer.append(this.formatInfo() + "</MINFO>\n");
        return buffer.toString();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof RsfMachineInfo && (this.feature != null && this.feature.equals(((RsfMachineInfo)o).feature) || this.feature == ((RsfMachineInfo)o).feature) && this.machineType.equals(((RsfMachineInfo)o).machineType) && this.machineModel.equals(((RsfMachineInfo)o).machineModel) && this.machineSerial.equals(((RsfMachineInfo)o).machineSerial);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected String formatInfo() {
        StringBuffer buffer = new StringBuffer("<MT>");
        buffer.append(this.machineType);
        buffer.append("</MT><MM>");
        buffer.append(this.machineModel);
        buffer.append("</MM><MS>");
        buffer.append(this.machineSerial);
        buffer.append("</MS>");
        return buffer.toString();
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer("<MINFO>");
        buffer.append(this.formatInfo() + "</MINFO>");
        return buffer.toString();
    }
}

